<?php  
/* 
Plugin Name: VC Waves Background
Version: 1.1
Author: Boom-Apps
Author URI: http://codecanyon.net/user/boom-apps
Description: Animated background for Visual Composer row
*/  

class VC_WavesBackground {
	
	
	function backendElement() {
		vc_map( array(
            "name" => __("VC Waves Background", 'vc_extend'),
            "description" => __("Creative backgrounds!", 'vc_extend'),
            "base" => "vc_wavesbackground",
            "class" => "",
            "controls" => "full",
			"params" => array(
              array("save_always" => true, "type" => "textarea", "holder" => "div", "class" => "", "heading" => "Id - unique per page", "param_name" => "theid", "value" => "vcwavesbackground_".time()."_".rand(100000,999999999) ),
              array("save_always" => true, "type" => "colorpicker", "class" => "", "heading" => "Background", "param_name" => "background", "value" => "#102030", "description" => ""),
			  array("save_always" => true, "type" => "dropdown", "class" => "", "heading" => "Fixed color?", "param_name" => "fixedhue", "value" => array("No" => "false", "Yes" => "true"), "description" => ""),
              array("save_always" => true, "type" => "textarea", "dependency" => array("element" => "fixedhue", "value" => array("true")), "class" => "", "heading" => "Fixed color hue", "param_name" => "fixedhuehue", "value" => "180", "description" => "Integer (0 - 360)"),
              array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Saturation", "param_name" => "saturation", "value" => "70", "description" => "Integer (0 - 100)"),
              array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Lightness", "param_name" => "lightness", "value" => "50", "description" => "Integer (0 - 100)"),
              array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Opacity", "param_name" => "opacity", "value" => "0.15", "description" => "Float (0.00 - 1.00)"),
			  array("save_always" => true, "type" => "dropdown", "class" => "", "heading" => "Node A position", "param_name" => "positionleft", "value" => array("Top left" => "topleft", "Center left" => "centerleft", "Bottom left" => "bottomleft", "Top center" => "topcenter"), "description" => ""),
			  array("save_always" => true, "type" => "dropdown", "class" => "", "heading" => "Node B position", "param_name" => "positionright", "value" => array("Bottom right" => "bottomright", "Center right" => "centerright", "Top right" => "topright", "Bottom center" => "bottomcenter"), "description" => ""),
              array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Fade speed", "param_name" => "fadespeed", "value" => "0.30", "description" => "Float (0.00 - 1.00)"),
              array("save_always" => true, "type" => "dropdown", "class" => "", "heading" => "Hide edges?", "param_name" => "hideedges", "value" => array("Yes" => "true", "No" => "false"), "description" => ""),
			  array("save_always" => true, "type" => "dropdown", "class" => "", "heading" => "Expand size?", "param_name" => "expand", "value" => array("No" => "false", "Yes" => "true"), "description" => ""),
              array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Speed", "param_name" => "speed", "value" => "4.00", "description" => "Float (0.00 - 6.00)"),
              array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "Number of lines", "param_name" => "particlecount", "value" => "20", "description" => "Integer (1 - 50)"),
              array("save_always" => true, "type" => "textarea", "class" => "", "heading" => "FPS", "param_name" => "fps", "value" => "30", "description" => "Integer (30 - 60)"),
             
			
			)
			
			
        ) );
		 
	}
	function theShortcode($Atts, $Content = null) {
		wp_enqueue_script(  array( 'jquery','canvaswaves','vc_wavesbackground' ) );
		wp_enqueue_style(  array( 'vc_wavesbackground' ) );
		
		$BgColor = self::convertColors($Atts['background']);
		$Atts['backgroundr'] = $BgColor['red'];
		$Atts['backgroundg'] = $BgColor['green'];
		$Atts['backgroundb'] = $BgColor['blue'];
		
		$Return = '<div id="'.$Atts['theid'].'" ';
		foreach ($Atts as $AttN => $AttV) {
			$Return .= 'data-'.str_replace("_","-",$AttN).'="'.$AttV.'" ';
		}
		$Return .= 'class="vc-waves-background" style="display:none;"></div>';
		
		return $Return;
	}
	
	
	function custom_css_classes_for_vc_row_and_vc_column( $class_string, $tag ) {
	  if ( $tag == 'vc_row' || $tag == 'vc_row_inner' ) {
		if (strpos($class_string,'boomapps_vcrow') == false) { $class_string = $class_string . " boomapps_vcrow"; } 
	  }
	  if ( $tag == 'vc_column' || $tag == 'vc_column_inner' ) {
		if (strpos($class_string,'boomapps_vccolumn') == false) { $class_string = $class_string . " boomapps_vccolumn"; }
	  }
	  return $class_string; 
	}
	
	
	function convertColors($hexStr, $returnAsString = false, $seperator = ',') {
		$hexStr = preg_replace("/[^0-9A-Fa-f]/", '', $hexStr); // Gets a proper hex string
		$rgbArray = array();
		if (strlen($hexStr) == 6) { //If a proper hex code, convert using bitwise operation. No overhead... faster
			$colorVal = hexdec($hexStr);
			$rgbArray['red'] = 0xFF & ($colorVal >> 0x10);
			$rgbArray['green'] = 0xFF & ($colorVal >> 0x8);
			$rgbArray['blue'] = 0xFF & $colorVal;
		} elseif (strlen($hexStr) == 3) { //if shorthand notation, need some string manipulations
			$rgbArray['red'] = hexdec(str_repeat(substr($hexStr, 0, 1), 2));
			$rgbArray['green'] = hexdec(str_repeat(substr($hexStr, 1, 1), 2));
			$rgbArray['blue'] = hexdec(str_repeat(substr($hexStr, 2, 1), 2));
		} else {
			return false; //Invalid hex color code
		}
		return $returnAsString ? implode($seperator, $rgbArray) : $rgbArray; // returns the rgb string or the associative array
	} 
	
	
	function registerStuff() {
		add_shortcode( 'vc_wavesbackground', array($this,'theShortcode') );	
		$this->backendElement();		
	}
	function registerScripts() {
		 wp_register_script( 'vc_wavesbackground', plugins_url('vcwavesbackground.js',__FILE__ ) );
		 wp_register_style( 'vc_wavesbackground', plugins_url('vcwavesbackground.css',__FILE__ ) );
		 wp_register_script( 'canvaswaves', plugins_url('_3rdparty/canvaswaves.js',__FILE__ ) );
		
	}
	function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'registerScripts') );
		add_action( 'init', array( $this, 'registerStuff') );	
		add_filter( 'vc_shortcodes_css_class', array($this,'custom_css_classes_for_vc_row_and_vc_column'), 10, 2 );
	}
}


/* Let's go! */
if (function_exists('vc_map')) {
	new VC_WavesBackground;
}

